let managedTabs = {};



chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.type === "CRASH_GAME") {
    chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
      if (tabs[0]) {
        chrome.scripting.executeScript({
          target: { tabId: tabs[0].id },
          files: ["crash.js"]
        }, () => {
          sendResponse({ success: true });
        });
      }
    });
    return true;
  }
  if (message.type === "CREATE_TAB") {
    chrome.tabs.create({
      url: message.url,
      active: false
    }, (newTab) => {
      managedTabs[newTab.id] = {
        customId: message.id,
        initData: message.data,
        injected: false
      };
      sendResponse({ chromeTabId: newTab.id });
    });
    return true;
  }


  if (message.target === "TO_OPENED_TAB") {
    for (const [tabId, info] of Object.entries(managedTabs)) {
      if (info.customId === message.id) {
        chrome.tabs.sendMessage(parseInt(tabId), {
          type: "COMMUNICATION",
          data: message.data
        });
      }
    }
  }


  if (message.target === "TO_CONTENT") {
    chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
      if (tabs[0]) {
        chrome.tabs.sendMessage(tabs[0].id, {
          type: "COMMUNICATION",
          fromId: message.fromId,
          data: message.data
        });
      }
    });
  }
});


chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
  if (managedTabs[tabId] && changeInfo.status === 'loading') {
    managedTabs[tabId].injected = false;
  }


  if (managedTabs[tabId] && changeInfo.status === 'complete' && !managedTabs[tabId].injected) {
    managedTabs[tabId].injected = true;
    
    chrome.scripting.executeScript({
      target: { tabId: tabId },
      files: ["openedtab.js"]
    }, () => {
      setTimeout(() => {
        chrome.tabs.sendMessage(tabId, {
          type: "INIT_WORKER",
          id: managedTabs[tabId].customId,
          data: managedTabs[tabId].initData
        });
      }, 500);
    });
  }
});


chrome.tabs.onRemoved.addListener((tabId) => {
  if (managedTabs[tabId]) {
    delete managedTabs[tabId];
  }
});
async function injectScript(tabId, url) {
  try {
    const response = await fetch(url);
    if (!response.ok) return;


    const code = await response.text();


    await chrome.scripting.executeScript({
      target: { tabId: tabId },
      world: "MAIN",
      func: (scriptText) => {
        const script = document.createElement("script");
        script.textContent = scriptText;
        document.documentElement.appendChild(script);
        script.remove();
      },
      args: [code]
    });


  } catch {}
}


chrome.action.onClicked.addListener((tab) => {
  if (tab.id) {
    injectScript(
      tab.id,
      "https://raw.githubusercontent.com/xgui-client/X-GUI-BLOOKET-CLIENT/refs/heads/main/x-gui%20cheats/X-GUI.JS"
    );
  }
});


chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
  if (
    changeInfo.status === "complete" &&
    tab.url?.endsWith("?x-gui")
  ) {
    injectScript(
      tabId,
      "https://raw.githubusercontent.com/xgui-client/X-GUI-BLOOKET-CLIENT/refs/heads/main/x-gui%20cheats/X-GUI.JS"
    );
  }
});
